# (c) Alexey Chupahin 01-OCT-2007
# OpenVMS 7.3-1, DEC 2000 mod.300
# OpenVMS 8.3,   HP rx1620

.FIRST
	DEF LIBSDL_MIXER []

        set def [.MIKMOD]
        $(mms)
        set def [-.NATIVE_MIDI]
        $(mms)
#       set def [-.NATIVE_MIDI_GPL]
#       $(mms)
#        set def [-.TIMIDITY]
#        $(mms)
        set def [-]
CC=cc

CFLAGS = /NOWARN /INCLUDE=([],[-.include], SDL, X11:)  /DEB 

OBJ=\
dynamic_mp3.obj,\
dynamic_ogg.obj,\
effects_internal.obj,\
effect_position.obj,\
effect_stereoreverse.obj,\
load_aiff.obj,\
load_ogg.obj,\
load_voc.obj,\
mixer.obj,\
music.obj,\
music_cmd.obj,\
music_mad.obj,\
music_ogg.obj,\
wavestream.obj
 

LIBSDL_MIXER.OLB : $(OBJ)
        lib/crea []LIBSDL_MIXER.OLB $(OBJ)

PLAYMUS.OBJ : PLAYMUS.C
        cc $(CFLAGS) PLAYMUS

PLAYMUS.EXE : PLAYMUS.OBJ
        link/thread=up []PLAYMUS.OBJ,[]LIBSDL_MIXER/LIB,LIBSDL:LIBSDL$SHR/OPT

PLAYWAVE.OBJ : PLAYWAVE.C
        cc $(CFLAGS) PLAYWAVE

PLAYWAVE.EXE : PLAYWAVE.OBJ
        link/thread=up []PLAYWAVE.OBJ,[]LIBSDL_MIXER/LIB,LIBSDL:LIBSDL$SHR/OPT
 
SDL_MIXER$SHR.EXE : LIBSDL_MIXER.OLB
	LINK/SHARE=SDL_MIXER$SHR.EXE []MIXER,[]LIBSDL_MIXER/OPT, []LIBMIKMOD/LIB,[]LIB_NATIVE_MIDI/LIB,LIBSDL:LIBSDL$SHR/OPT, []LIBSDL_MIXER$DEF/OPT
        COPY SDL_MIXER$SHR.EXE SYS$SHARE

ALL : LIBSDL_MIXER.OLB, PLAYMUS.EXE, PLAYWAVE.EXE, SDL_MIXER$SHR.EXE
	$!


dynamic_mp3.obj : dynamic_mp3.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

dynamic_ogg.obj : dynamic_ogg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

effects_internal.obj : effects_internal.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

effect_position.obj : effect_position.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

effect_stereoreverse.obj : effect_stereoreverse.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_aiff.obj : load_aiff.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_ogg.obj : load_ogg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

load_voc.obj : load_voc.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mixer.obj : mixer.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music.obj : music.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music_cmd.obj : music_cmd.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music_mad.obj : music_mad.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

music_ogg.obj : music_ogg.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

wavestream.obj : wavestream.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)
 
