$! (c) Alexey Chupahin  12-NOV-2007
$! GNU
$!
$!
$ SET NOON
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Configuring SDL_HEXEN"
$WRITE SYS$OUTPUT "(c) Alexey Chupahin (aka CHAPG) "
$WRITE SYS$OUTPUT " "
$! Checking architecture
$DECC = F$SEARCH("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. ""
$    IF F$GETSYI("ARCH_TYPE").EQ.1 THEN CPU = "VAX"
$    IF F$GETSYI("ARCH_TYPE").EQ.2 THEN CPU = "Alpha"
$    IF F$GETSYI("ARCH_TYPE").EQ.3 THEN CPU = "I64"
$    OS = F$GETSYI("VERSION")
$WRITE SYS$OUTPUT "Checking architecture   ...  ", CPU
$WRITE SYS$OUTPUT "Checking OS             ...  OpenVMS ",OS
$SHARED=0
$IF ( (CPU.EQS."Alpha").OR.(CPU.EQS."I64") )
$  THEN
$       SHARED=64
$  ELSE
$       SHARED=32
$ENDIF
$!
$IF (DECC) THEN $WRITE SYS$OUTPUT  "Compiler		...  DEC C"
$IF (.NOT. DECC) THEN $WRITE SYS$OUTPUT  "BAD compiler" GOTO EXIT
$MMS = F$SEARCH("SYS$SYSTEM:MMS.EXE") .NES. ""
$MMK = F$TYPE(MMK) 
$IF (MMS .OR. MMK.NES."") THEN GOTO TEST_LIBRARIES
$! I cant find any make tool
$GOTO EXIT
$!
$!
$TEST_LIBRARIES:
$!   Setting as MAKE utility one of MMS or MMK. I prefer MMS.
$IF (MMK.NES."") THEN MAKE="MMK"
$IF (MMS) THEN MAKE="MMS/ignore=warning"
$WRITE SYS$OUTPUT "Checking build utility	...  ''MAKE'"
$WRITE SYS$OUTPUT " "
$!
$!
$!"Checking for correct SDL library"
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ LIBSDL_STATIC=0
$ CC/name=(as_is,short)/float=ieee/OBJECT=TEST.OBJ/INCLUDE=(SDL) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>

int main(int argc, char *argv[])
{
        SDL_version compiled;

        /* Initialize SDL */
        if ( SDL_Init(0) < 0 ) {
                fprintf(stderr, "Couldn't initialize SDL: %s\n",SDL_GetError());                exit(2);
        }
#ifdef DEBUG
        fprintf(stderr, "SDL initialized\n");
#endif

#if SDL_VERSION_ATLEAST(1, 2, 14)
#elif defined (VMS_PATCH)
        printf("checking version libSDL  : %d.%d.%d%s\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch,
				VMS_PATCH);
        SDL_Quit();
        return(0);
#else
        printf("checking version libSDL  : %d.%d.%d\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch);
        printf("libSDL is too old. Please get newest\n");
        printf("From http://fafner.dyndns.org/~alexey/libsdl/public.html\n");
	exit(2);
#endif
        printf("checking version libSDL  : %d.%d.%d\n",
                        SDL_Linked_Version()->major,
                        SDL_Linked_Version()->minor,
                        SDL_Linked_Version()->patch);
        SDL_Quit();
        return(0);
}

$TMP = $STATUS
$DEASS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_LIBSDL=0
$       GOTO NEXT0
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS
$IF (TMP .NE. %X10000001 .and. tmp .ne. %X10648268 )
$  THEN
$       LINK/EXE=TEST TEST,LIBSDL:LIBSDL/OPT
$       TMP = $STATUS
$       IF (TMP .NE. %X10000001 .and. tmp .ne. %X10648268 )
$         THEN
$               TMP = $STATUS
$               HAVE_LIBSDL=0
$               GOTO NEXT0
$         ELSE
$               LIBSDL_STATIC=1
$       ENDIF
$ENDIF
$!
$DEAS  SYS$OUTPUT
$RUN TEST
$IF ($STATUS .NE. %X00000001)
$  THEN
$       HAVE_LIBSDL=0
$	GOTO NEXT0
$  ELSE
$        HAVE_LIBSDL=1
$ENDIF
$DEAS  SYS$ERROR
$NEXT0:
$IF (HAVE_LIBSDL.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for correct libSDL  ...   No"
$	GOTO EXIT
$ENDIF
$!
$!
$!"Checking for audio SDL subsystem"
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ HAVE_SOUND=0
$ CC/name=(as_is,short)/float=ieee/OBJECT=TEST.OBJ/INCLUDE=(SDL) SYS$INPUT
#include <stdio.h>
#include <stdlib.h>
#include <SDL.h>
int main(int argc, char **argv)
{
    if( SDL_Init( SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_CDROM ) < 0 )
    {
        fprintf( stderr, "Couldn't initialize SDL: %s\n", SDL_GetError() );
            exit( 2 );
    }
   SDL_Quit();
        return(0);
}

$TMP = $STATUS
$DEAS SYS$ERROR
$DEAS  SYS$OUTPUT
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_SOUND=0
$       GOTO NEXT1
$ENDIF
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST,LIBSDL:LIBSDL$SHR/OPT
$TMP = $STATUS
$IF (TMP .NE. %X10000001 .and. tmp .ne. %X10648268 )
$  THEN
$       LINK/EXE=TEST TEST,LIBSDL:LIBSDL/OPT
$       TMP = $STATUS
$       IF (TMP .NE. %X10000001  .and. tmp .ne. %X10648268 )
$         THEN
$               TMP = $STATUS
$               HAVE_SOUND=0
$               GOTO NEXT1
$         ELSE
$               HAVE_SOUND=0
$       ENDIF
$ENDIF
$!
$!RUN TEST
$!IF ($STATUS .NE. %X00000001)
$!  THEN
$!       HAVE_SOUND=0
$!       GOTO NEXT1
$!  ELSE
$        HAVE_SOUND=0
$!ENDIF
$NEXT1:
$DEAS  SYS$OUTPUT
$DEAS  SYS$ERROR
$IF (HAVE_SOUND.EQ.1)
$  THEN
$       WRITE SYS$OUTPUT "Checking for sound subsystem  ...   Yes"
$  ELSE
$       WRITE SYS$OUTPUT "Checking for sound subsystem  ...   No"
$ENDIF
$!
$!
$! Checking vsnprintf
$!
$ DEFINE SYS$ERROR _NLA0:
$ DEFINE SYS$OUTPUT _NLA0:
$ CC/name=(as_is,short)/float=ieee/OBJECT=TEST.OBJ SYS$INPUT
   #include <stdio.h>
   #include <stdlib.h>
   #include <varargs.h>
   int main()
     {
        char *s=malloc(12);                            
        int  i = vsnprintf(s,(size_t)11,"",(va_list) NULL);
	free(s);
     }
$!                                                     
$TMP = $STATUS
$DEAS SYS$ERROR                                       
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP                                 
$IF (TMP .NE. %X10B90001)
$  THEN
$       HAVE_VSNPRINTF=0                               
$       GOTO NEXT5                                     
$ENDIF
$DEFINE SYS$ERROR _NLA0:                               
$DEFINE SYS$OUTPUT _NLA0:
$LINK/EXE=TEST TEST                                    
$TMP = $STATUS
$DEAS  SYS$ERROR                                       
$DEAS  SYS$OUTPUT
$!WRITE SYS$OUTPUT TMP                                 
$IF (TMP .NE. %X10000001)
$  THEN                                                
$       HAVE_VSNPRINTF=0                               
$       GOTO NEXT5                                     
$  ELSE                                                
$       HAVE_VSNPRINTF=1                               
$ENDIF                                                 
$NEXT5:                                                
$IF (HAVE_VSNPRINTF.EQ.1)                              
$  THEN                                                
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   Yes"
$  ELSE                                                
$       WRITE SYS$OUTPUT "Checking for vsnprintf ...   No"
$ENDIF                                                 
$!                                                     
$!
$WRITE SYS$OUTPUT "Generating DESCRIP.MMS"
$COPY SYS$INPUT DESCRIP.MMS
# (c) Alexey Chupahin 31-DEC-2008
# OpenVMS 7.3-2, DEC 2000 model 300
# OpenVMS 8.2,   Compaq DS10L
# OpenVMS 8.3,   HP rx1620

CC=cc

$IF HAVE_SOUND.EQ.1
$ THEN
$	APP SYS$INPUT DESCRIP.MMS
CFLAGS = /INCLUDE=([], SDL ) /DEFINE=(SDL,DEMO_WAD,"alloca"=__ALLOCA,HAVE_AUDIO)\
$ ELSE
$	APP SYS$INPUT DESCRIP.MMS
CFLAGS = /INCLUDE=([], SDL ) /DEFINE=(SDL,DEMO_WAD,"alloca"=__ALLOCA)\
$ENDIF
$!
$!
$APP SYS$INPUT DESCRIP.MMS
        /name=(as_is,short)/OPTIMIZE=INLINE=SPEED /NOMEMBER /FLOAT=IEEE /IEEE=DENORM /WARN=(DIS=(FOUNDCR,UNDEFVARMOD,EMPTYFILE,PTRMISMATCH1))

OBJ=\
am_map.obj,\
a_action.obj,\
ct_chat.obj,\
d_net.obj,\
f_finale.obj,\
g_game.obj,\
h2_main.obj,\
info.obj,\
in_lude.obj,\
i_cdmus_sdl.obj,\
i_cyber.obj,\
i_sdl.obj,\
i_sound.obj,\
mn_menu.obj,\
m_misc.obj,\
po_man.obj,\
p_acs.obj,\
p_anim.obj,\
p_ceilng.obj,\
p_doors.obj,\
p_enemy.obj,\
p_floor.obj,\
p_inter.obj,\
p_lights.obj,\
p_map.obj,\
p_maputl.obj,\
p_mobj.obj,\
p_plats.obj,\
p_pspr.obj,\
p_setup.obj,\
p_sight.obj,\
p_spec.obj,\
p_switch.obj,\
p_telept.obj,\
p_things.obj,\
p_tick.obj,\
p_user.obj,\
r_bsp.obj,\
r_data.obj,\
r_draw.obj,\
r_main.obj,\
r_plane.obj,\
r_segs.obj,\
r_things.obj,\
sb_bar.obj,\
sc_man.obj,\
sn_sonix.obj,\
sounds.obj,\
st_start.obj,\
sv_save.obj,\
tables.obj,\
template.obj,\
v_video.obj,\
w_wad.obj,\
z_zone.obj

ALL : SDL_HEXEN.EXE
        $!


HEXEN.OLB : $(OBJ)
        LIB/CRE HEXEN $(OBJ)

am_map.obj : am_map.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

a_action.obj : a_action.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

ct_chat.obj : ct_chat.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

d_net.obj : d_net.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

f_finale.obj : f_finale.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

g_game.obj : g_game.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

h2_main.obj : h2_main.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

info.obj : info.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

in_lude.obj : in_lude.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_cdmus.obj : i_cdmus.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_cdmus_sdl.obj : i_cdmus_sdl.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_cyber.obj : i_cyber.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_ibm.obj : i_ibm.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_sdl.obj : i_sdl.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_sound.obj : i_sound.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

i_svgalib.obj : i_svgalib.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

mn_menu.obj : mn_menu.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

m_misc.obj : m_misc.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

po_man.obj : po_man.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_acs.obj : p_acs.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_anim.obj : p_anim.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_ceilng.obj : p_ceilng.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_doors.obj : p_doors.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_enemy.obj : p_enemy.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_floor.obj : p_floor.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_inter.obj : p_inter.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_lights.obj : p_lights.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_map.obj : p_map.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_maputl.obj : p_maputl.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_mobj.obj : p_mobj.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_plats.obj : p_plats.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_pspr.obj : p_pspr.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_setup.obj : p_setup.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_sight.obj : p_sight.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_spec.obj : p_spec.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_switch.obj : p_switch.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_telept.obj : p_telept.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_things.obj : p_things.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_tick.obj : p_tick.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

p_user.obj : p_user.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_bsp.obj : r_bsp.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_data.obj : r_data.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_draw.obj : r_draw.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_main.obj : r_main.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_plane.obj : r_plane.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_segs.obj : r_segs.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

r_things.obj : r_things.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sb_bar.obj : sb_bar.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sc_man.obj : sc_man.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sn_sonix.obj : sn_sonix.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sounds.obj : sounds.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

st_start.obj : st_start.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

sv_save.obj : sv_save.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

tables.obj : tables.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

template.obj : template.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

v_video.obj : v_video.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

w_wad.obj : w_wad.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)

z_zone.obj : z_zone.c
         $(CC) $(CFLAGS) $(MMS$SOURCE) /OBJ=$(MMS$TARGET)
 
$IF LIBSDL_STATIC.EQ.1
$ THEN
$	APP SYS$INPUT  DESCRIP.MMS
SDL_HEXEN.EXE : r_main.obj,HEXEN.OLB
        LINK/EXE=SDL_HEXEN/THREAD=UP r_main,hexen/lib,libsdl:libsdl/opt
$ ELSE
$	APP SYS$INPUT  DESCRIP.MMS
SDL_HEXEN.EXE : r_main.obj,HEXEN.OLB
        LINK/EXE=SDL_HEXEN/THREAD=UP r_main,hexen/lib,libsdl:libsdl$shr/opt
$ENDIF
$!
$! 
$WRITE SYS$OUTPUT "Generating BUILD.COM "
$OPEN/WRITE OUT BUILD.COM
$WRITE OUT "$",MAKE,"/IGN=WAR"
$CLOSE OUT
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT " "
$WRITE SYS$OUTPUT "Now you can type @BUILD "
$!
$EXIT:
$DEFINE SYS$ERROR _NLA0:
$DEFINE SYS$OUTPUT _NLA0:
$DEL TEST.OBJ;*
$DEL TEST.C;*
$DEL TEST.EXE;*
$DEAS SYS$ERROR
$DEAS SYS$OUTPUT
